package com.digiwin.dap.middle.ram.service.base;

import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.mapper.RamRouteCrudMapper;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamRouteCrudService implements RamBaseService<Route> {

    @Autowired
    private RamRouteCrudMapper ramRouteCrudMapper;

    @Override
    public long insert(Route data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        ramRouteCrudMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramRouteCrudMapper.deleteBySid(sid);
    }

    @Override
    public long update(Route data) {
        BaseUtils.setCreateFields(data);
        ramRouteCrudMapper.update(data);
        return data.getSid();
    }

    @Override
    public Route findBySid(long sid) {
        return ramRouteCrudMapper.findBySid(sid);
    }

    @Override
    public boolean existsBySid(long sid) {
        return ramRouteCrudMapper.existsBySid(sid);
    }

    @Override
    public PageData<Route> findByPage(Page page) {
        long total = ramRouteCrudMapper.countByPage(page);
        if (total == 0) {
            return PageData.empty();
        }
        List<Route> routes = ramRouteCrudMapper.findByPage(page.offsetPage());
        return PageData.data(total, routes);
    }

    public PageData<RouteVO> findByPage0(Page page) {
        long total = ramRouteCrudMapper.countByPage(page);
        if (total == 0) {
            return PageData.empty();
        }
        List<RouteVO> paths = ramRouteCrudMapper.findByPageCount(page.offsetPage());
        return PageData.data(total, paths);
    }
}
