package com.digiwin.dap.middle.ram.service.executor;

import com.digiwin.dap.middleware.constant.CacheConstants;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;

import java.util.List;

@CacheConfig(cacheNames = CacheConstants.TTL_12H, cacheManager = CacheConstants.DAP_CACHE_MANAGER)
public class GrantCachingExecutor implements GrantExecutor {

    private final GrantExecutor delegate;

    public GrantCachingExecutor(GrantExecutor delegate) {
        this.delegate = delegate;
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_GRANT + #policyType + ':' + #targetType + ':' + #targetId")
    @Override
    public List<String> findPolicyIdByTarget(String policyType, String targetType, String targetId) {
        return delegate.findPolicyIdByTarget(policyType, targetType, targetId);
    }
}
