package com.digiwin.dap.middle.ram.service.executor;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middleware.constant.CacheConstants;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;

import java.util.List;

@CacheConfig(cacheNames = CacheConstants.TTL_12H, cacheManager = CacheConstants.DAP_CACHE_MANAGER)
public class PolicyCachingExecutor implements PolicyExecutor {

    private final PolicyExecutor delegate;

    public PolicyCachingExecutor(PolicyExecutor delegate) {
        this.delegate = delegate;
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_POLICY + #policyType + ':' + #policyId")
    @Override
    public List<PatternVO> findPolicyById(String policyType, String policyId) {
        return delegate.findPolicyById(policyType, policyId);
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_POLICY + #policyType")
    @Override
    public List<PatternVO> findPolicyByType(String policyType) {
        return delegate.findPolicyByType(policyType);
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_POLICY + #policyType + ':{' + #method + ' ' + #path + '}'")
    @Override
    public List<String> findPolicyIdByPath(String policyType, String method, String path) {
        return delegate.findPolicyIdByPath(policyType, method, path);
    }
}

