package com.digiwin.dap.middle.ram.service.policy.auth;

import com.digiwin.dap.middle.ram.domain.AuthResult;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.AuthType;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;

import javax.servlet.http.HttpServletRequest;

/**
 * App授权检查
 *
 * @author fobgo
 * @date 2022/4/11 14:57
 */
public abstract class AuthCheckHandler {

    protected PolicyQueryService policyQueryService;

    /**
     * 是否支持此 授权检查处理器
     *
     * @param authType 授权检查结果
     * @return 是否支持此
     */
    public abstract boolean supports(AuthType authType);

    /**
     * 查询是否有应用授权
     *
     * @param targetInfo 登录信息
     * @param request    请求
     * @return 授权信息
     */
    public AuthResult processAuth(TargetInfo targetInfo, HttpServletRequest request) {
        AuthResult authResult = this.processAuth(targetInfo.getAuthResult(), targetInfo.getUser(), targetInfo.getSys());
        targetInfo.setAuthResult(authResult);
        return authResult;
    }

    public AuthResult processAuthWithCheck(TargetInfo targetInfo, HttpServletRequest request) {
        return null;
    }

    /**
     * 查询是否有应用授权
     *
     * @param authResult 授权信息
     * @param user       登录用户
     * @param sys        登录应用
     * @return 授权信息
     */
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys) {
        return authResult;
    }

    public AuthResult processAuthWithCheck(AuthResult authResult, AuthoredUser user, AuthoredSys sys) {
        return authResult;
    }
}
