package com.digiwin.dap.middle.ram.service.policy.auth;

import com.digiwin.dap.middle.ram.constant.I18nError;
import com.digiwin.dap.middle.ram.domain.AuthResult;
import com.digiwin.dap.middle.ram.domain.enums.AuthType;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.exception.BusinessException;
import org.springframework.core.annotation.Order;

/**
 * AppTokenValidBeforeAuthCheckHandler.java
 *
 * @author fobgo
 * @date 2022/4/14 14:45
 */
@Order(0)
public class BeforeAuthCheckHandler extends AuthCheckHandler {

    private final DapEnv dapEnv;

    public BeforeAuthCheckHandler(DapEnv dapEnv, PolicyQueryService policyQueryService) {
        this.dapEnv = dapEnv;
        this.policyQueryService = policyQueryService;
    }

    @Override
    public boolean supports(AuthType authType) {
        return true;
    }

    @Override
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys) {
        if (authResult.isDisabled()) {
            authResult.setAuthType(AuthType.AppOk);
            return authResult;
        }
        /*
          开启授权检查，则必须传AppToken
          IAM：app-check: true && sys == null
         */
        boolean needCheck = dapEnv.isRamAppCheck() && sys == null;
        if (needCheck) {
            throw new BusinessException(I18nError.APP_TOKEN_NONE);
        }

        /*
         下列情况不用检查授权信息
         1. 没有租户
         2. 没有应用、
         3. 内部应用、
         4、集成账号+digiwin应用
        */
        boolean notCheck = user == null || user.getTenantId() == null ||
                sys == null || sys.getId() == null || sys.isInside() ||
                "integration".equals(user.getUserId());
        if (notCheck) {
            authResult.setAuthType(AuthType.AppOk);
        }
        return authResult;
    }
}
