package com.digiwin.dap.middle.ram.service.policy.auth;

import com.digiwin.dap.middle.ram.domain.AuthResult;
import com.digiwin.dap.middle.ram.domain.enums.AuthType;
import com.digiwin.dap.middle.ram.service.AuthCheckService;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import org.springframework.core.annotation.Order;

/**
 * 查询授权信息
 *
 * @author fobgo
 * @date 2022/4/11 15:04
 */
@Order(10)
public class DoAuthCheckHandler extends AuthCheckHandler {

    private final AuthCheckService authCheckService;

    public DoAuthCheckHandler(AuthCheckService authCheckService) {
        this.authCheckService = authCheckService;
    }

    @Override
    public boolean supports(AuthType authType) {
        // 授权状态不明确才需要区CAC查询
        return authType == null;
    }

    @Override
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys) {
        return authCheckService.processAuth(authResult, user, sys);
    }
}
