package com.digiwin.dap.middle.ram.service.policy.auth;

import com.digiwin.dap.middle.ram.domain.AuthResult;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.AuthType;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.filter.MappingRegistry;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import org.springframework.core.annotation.Order;

import javax.servlet.http.HttpServletRequest;

/**
 * 不做授权检查，策略类型 {@link PolicyType#NoAuth}
 *
 * @author fobgo
 * @date 2022/4/11 15:04
 */
@Order(5)
public class NoAuthAuthCheckHandler extends AuthCheckHandler {

    private HttpServletRequest request;

    public NoAuthAuthCheckHandler(PolicyQueryService policyQueryService) {
        this.policyQueryService = policyQueryService;
    }

    @Override
    public boolean supports(AuthType authType) {
        return true;
    }

    @Override
    public AuthResult processAuth(TargetInfo targetInfo, HttpServletRequest request) {
        this.request = request;
        return super.processAuth(targetInfo, request);
    }

    @Override
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys) {
        if (request == null) {
            return authResult;
        }
        MappingRegistry mappingRegistry = policyQueryService.getPattern(PolicyType.NoAuth.name());
        boolean matched = MatcherUtils.matches(request, mappingRegistry);
        if (matched) {
            authResult.setAuthType(AuthType.AppOk);
        }
        return authResult;
    }
}
