package com.digiwin.dap.middle.ram.service.policy.auth;

import com.digiwin.dap.middle.ram.domain.AuthResult;
import com.digiwin.dap.middle.ram.domain.enums.AuthType;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import org.springframework.core.annotation.Order;

import java.util.List;

/**
 * 不做授权检查，策略类型 {@link PolicyType#NoAuthUser}
 *
 * @author fobgo
 * @date 2022/4/11 15:04
 */
@Order(20)
public class NoAuthUserAuthCheckHandler extends AuthCheckHandler {

    public NoAuthUserAuthCheckHandler(PolicyQueryService policyQueryService) {
        this.policyQueryService = policyQueryService;
    }

    @Override
    public boolean supports(AuthType authType) {
        return authType == AuthType.AppNoneUser;
    }

    @Override
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys) {
        List<String> policyId = policyQueryService.findPolicyIdByTarget(PolicyType.NoAuthUser.name(),
                TargetType.TenantSys.name(), user.getTenantId() + '-' + sys.getId());
        if (!policyId.isEmpty()) {
            // 租户-应用设定，已经购买，未添加用户授权，直接放行
            authResult.setAuthType(AuthType.AppOk);
        }
        return authResult;
    }
}
