package com.digiwin.dap.middle.ram.service.policy.filiter;

import com.digiwin.dap.middle.ram.filter.MappingRegistry;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.service.TargetTypeChain;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import org.springframework.core.annotation.Order;

import javax.servlet.http.HttpServletRequest;
import java.util.Collections;

/**
 * 白名单，策略类型 {@link PolicyType#AllowList}
 * <p>
 * 该策略下的API，目标设定拥有该策略才可以访问，其他目标一律不能访问
 *
 * @author fobgo
 * @date 2021/9/18 21:04
 */
@Order(2)
public class AllowListPolicyFilterHandler extends PolicyFilterHandler {

    public AllowListPolicyFilterHandler(PolicyQueryService policyQueryService) {
        super(policyQueryService);
    }

    @Override
    public ResultType matches(TargetInfo targetInfo, HttpServletRequest request) {
        // 1.查询所有白名单API
        MappingRegistry mappingRegistry = policyQueryService.getPattern(PolicyType.AllowList.name());
        if (!mappingRegistry.isEmpty()) {
            // 2.当前访问API和白名单集合进行匹配
            boolean matched = MatcherUtils.matches(request, mappingRegistry);
            if (matched) {
                // 2.1.当前API在白名单集合中，依次进行匹配
                ResultType resultType = TargetTypeChain.getInstance(this, targetInfo.targets()).matches(targetInfo, request);
                // 3.有则允许，没有则拒绝
                return resultType == ResultType.ALLOW ? ResultType.ALLOW : ResultType.EXPLICIT_DENY;
            }
        }
        // 2.2.当前API不在白名单集合中
        return ResultType.IMPLICIT_DENY;
    }

    @Override
    public ResultType matches(String targetType, String targetId, HttpServletRequest request) {
        return super.matches(PolicyType.AllowList.name(), targetType, targetId, request);
    }
}
