package com.digiwin.dap.middle.ram.service.policy.filiter;

import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.service.TargetTypeChain;
import org.springframework.core.annotation.Order;

import javax.servlet.http.HttpServletRequest;

/**
 * 功能权限，策略类型 {@link PolicyType#Base}
 * <p>
 * 系统策略和用户自定义策略，按照最小单元判定流程匹配 {@link ResultType}
 *
 * @author fobgo
 * @date 2021/9/18 21:04
 */
@Order(4)
public class BasePolicyFilterHandler extends PolicyFilterHandler {

    public BasePolicyFilterHandler(PolicyQueryService policyQueryService) {
        super(policyQueryService);
    }

    @Override
    public ResultType matches(TargetInfo targetInfo, HttpServletRequest request) {
        return TargetTypeChain.getInstance(this, targetInfo.targets()).matches(targetInfo, request);
    }

    @Override
    public ResultType matches(String targetType, String targetId, HttpServletRequest request) {
        return super.matches(PolicyType.Base.name(), targetType, targetId, request);
    }
}
