package com.digiwin.dap.middle.ram.service.policy.filiter;

import com.digiwin.dap.middle.ram.filter.MappingRegistry;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import org.springframework.core.annotation.Order;

import javax.servlet.http.HttpServletRequest;

/**
 * 全局不参与，策略类型 {@link PolicyType#None}
 * <p>
 * 该策略下的API不做管控
 *
 * @author fobgo
 * @date 2021/9/18 21:03
 */
@Order(1)
public class NonePolicyFilterHandler extends PolicyFilterHandler {

    public NonePolicyFilterHandler(PolicyQueryService policyQueryService) {
        super(policyQueryService);
    }

    @Override
    public ResultType matches(TargetInfo targetInfo, HttpServletRequest request) {
        MappingRegistry mappingRegistry = policyQueryService.getPattern(PolicyType.None.name());
        boolean matched = MatcherUtils.matches(request, mappingRegistry);
        if (matched) {
            return ResultType.ALLOW;
        }
        return ResultType.IMPLICIT_DENY;
    }
}
