package com.digiwin.dap.middle.ram.service.policy.filiter;

import com.digiwin.dap.middle.ram.filter.MappingRegistry;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import org.springframework.core.annotation.Order;

import javax.servlet.http.HttpServletRequest;

/**
 * 废弃API策略，策略类型 {@link PolicyType#Obsolete}
 * <p>
 * 该策略下的API都废弃 无法使用
 *
 * @author fobgo
 * @date 2021/9/18 21:03
 */
@Order(5)
public class ObsoletePolicyFilterHandler extends PolicyFilterHandler {

    public ObsoletePolicyFilterHandler(PolicyQueryService policyQueryService) {
        super(policyQueryService);
    }

    @Override
    public ResultType matches(TargetInfo targetInfo, HttpServletRequest request) {
        return this.matches(request);
    }

    @Override
    public ResultType matches(HttpServletRequest request) {
        MappingRegistry mappingRegistry = policyQueryService.getPattern(PolicyType.Obsolete.name());
        boolean matched = MatcherUtils.matches(request, mappingRegistry);
        if (matched) {
            return ResultType.OBSOLETE_DENY;
        }
        return ResultType.IMPLICIT_DENY;
    }
}
