package com.digiwin.dap.middle.ram.util;

import com.digiwin.dap.middle.ram.constant.I18nError;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.AuthType;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.exception.UnauthorizedException;

/**
 * 授权检查异常处理
 *
 * @author fobgo
 * @date 2022/4/14 11:37
 */
public class AuthUtils {

    public static void checkAuthResult(TargetInfo targetInfo) {
        checkAuthResult(targetInfo.getAuthResult().getAuthType(), targetInfo.getUser(), targetInfo.getSys());
    }

    /**
     * {@link  AuthType}
     *
     * @author fobgo
     * @date 2022/4/14 11:40
     */
    public static void checkAuthResult(AuthType authType, AuthoredUser user, AuthoredSys sys) {
        if (authType == AuthType.AppNone) {
            String message = String.format("租户[%s]尚未购买应用[%s]", user.getTenantId(), sys.getId());
            throw new UnauthorizedException(I18nError.AUTH_CHECK_21006, 411002, message);
        }
        if (authType == AuthType.AppExpired) {
            String message = String.format("租户[%s]购买的应用[%s]授权已过期", user.getTenantId(), sys.getId());
            throw new UnauthorizedException(I18nError.AUTH_CHECK_21008, 411004, message);
        }
        if (authType == AuthType.AppNoneUser) {
            String message = String.format("租户[%s]用户[%s]尚未得到应用[%s]的授权", user.getTenantId(), user.getUserId(), sys.getId());
            throw new UnauthorizedException(I18nError.AUTH_CHECK_21007, 411003, message);
        }
    }
}
