package com.digiwin.dap.middle.ram.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;

/**
 * JdbcUtils
 *
 * @author Xiao
 * @date 2021/8/16 18:22
 */
public class JdbcUtils {

    private static final Logger logger = LoggerFactory.getLogger(JdbcUtils.class);
    private static final String QUERY_TABLE_EXISTS = "show tables like '%s'";
    private final static int DEFAULT_BUFFER_SIZE = 1024 * 4;

    public static void createTables(JdbcTemplate jdbcTemplate) {
        String[] resources = new String[]{
                "ram_grant", "ram_grant_policy",
                "ram_policy", "ram_policy_route",
                "ram_route"
        };
        for (String table : resources) {
            String path = "/support/" + table + ".sql";
            try {
                final boolean next = jdbcTemplate.queryForRowSet(String.format(QUERY_TABLE_EXISTS, table)).next();
                if (next) {
                    logger.debug("table {} has been created.", table);
                } else {
                    String tableInfo = JdbcUtils.readFromResource(path);
                    jdbcTemplate.execute(tableInfo);
                }
            } catch (Exception e) {
                logger.error("create table error {}", e.getMessage());
            }
        }
    }

    public static void exec(JdbcTemplate jdbcTemplate, String sqls) {
        String[] sqlArray = sqls.split(";");
        for (String sql : sqlArray) {
            jdbcTemplate.execute(sql);
        }
    }

    private static String readFromResource(String resource) throws IOException {
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            if (in == null) {
                in = JdbcUtils.class.getResourceAsStream(resource);
            }
            if (in == null) {
                return null;
            }
            return JdbcUtils.read(in);
        } finally {
            in.close();
        }
    }

    private static String read(InputStream in) {
        InputStreamReader reader;
        reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return read(reader);
    }

    private static String read(Reader reader) {
        try {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[DEFAULT_BUFFER_SIZE];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            return writer.toString();
        } catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }
}
