package com.digiwin.dap.middle.ram.util;

import com.digiwin.dap.middle.ram.filter.MappingRegistry;
import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.filter.PatternRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * 路径匹配
 *
 * @author fobgo
 * @date 2021/10/14 11:39
 */
public class MatcherUtils {

    private static final Logger logger = LoggerFactory.getLogger(MatcherUtils.class);
    private static PatternRegistry patternRegistry;

    public static boolean matches(HttpServletRequest request, MappingRegistry mappingRegistry) {
        List<PatternVO> directPathMatches = mappingRegistry.getMappingsByUrl(request.getServletPath());
        if (directPathMatches != null) {
            for (PatternVO mapping : directPathMatches) {
                if (mapping.getMethod() == null || mapping.getMethod().equals(request.getMethod())) {
                    logger.debug("matched " + mapping);
                    return true;
                }
            }
        }
        for (RequestMatcher mapping : getAntMatchers(mappingRegistry.getMappings())) {
            if (mapping.matches(request)) {
                logger.debug("matched " + mapping);
                return true;
            }
        }
        logger.debug("No matches found");
        return false;
    }

    private static List<RequestMatcher> getAntMatchers(List<PatternVO> mappings) {
        List<RequestMatcher> matchers = new ArrayList<>();
        for (PatternVO mapping : mappings) {
            if (patternRegistry.getRegistry().containsKey(mapping)) {
                matchers.add(patternRegistry.getRegistry().get(mapping));
            } else {
                AntPathRequestMatcher matcher = new AntPathRequestMatcher(mapping.getPath(), mapping.getMethod());
                matchers.add(matcher);
                patternRegistry.register(mapping, matcher);
            }
        }
        return matchers;
    }

    public static void setRouteRegistry(PatternRegistry patternRegistry) {
        MatcherUtils.patternRegistry = patternRegistry;
    }
}
