/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.service.CacheHandlerService;
import com.digiwin.dap.middle.ram.service.base.RamGrantCrudService;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/ram/v2/grant"})
@RestController
public class GrantApi {
    @Autowired
    private RamGrantCrudService ramGrantCrudService;
    @Autowired
    private CacheHandlerService cacheHandlerService;
    @Autowired
    private RamGrantPolicyCrudService ramGrantPolicyCrudService;

    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody Grant body) {
        long sid = this.ramGrantCrudService.insert(body);
        return StdData.ofSuccess((Object)BaseSid.ok(sid));
    }

    @Transactional
    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody BaseSid body) {
        Grant grant = this.ramGrantCrudService.findBySid(body.getSid());
        if (grant != null) {
            this.cacheHandlerService.grantChanged(grant.getType(), grant.getTargetId());
            int count = this.ramGrantCrudService.deleteBySid(body.getSid());
            this.ramGrantPolicyCrudService.deleteByGrantSid(body.getSid());
            return StdData.ofSuccess((Object)BaseSid.ok(count));
        }
        return StdData.ofSuccess((Object)BaseSid.ok(0L));
    }

    @PostMapping(value={"/get"})
    public StdData<?> get(@RequestBody BaseSid body) {
        Grant grant = this.ramGrantCrudService.findBySid(body.getSid());
        if (grant != null) {
            return StdData.ofSuccess((Object)grant);
        }
        return StdData.ofSuccess((Object)BaseSid.ok(0L));
    }

    @PostMapping(value={"/find"})
    public StdData<?> find(@RequestBody GrantVO body) {
        body.setOrderBy("g.create_date desc");
        return StdData.ofSuccess(this.ramGrantCrudService.findByPage(body));
    }

    @PostMapping(value={"/query"})
    public StdData<?> query(@RequestBody GrantVO body) {
        body.setOrderBy("g.create_date desc");
        return StdData.ofSuccess(this.ramGrantCrudService.findByPage0(body));
    }
}

