/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.GrantPolicy;
import com.digiwin.dap.middle.ram.service.CacheHandlerService;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/ram/v2/gp"})
@RestController
public class GrantPolicyApi {
    @Autowired
    private CacheHandlerService cacheHandlerService;
    @Autowired
    private RamGrantPolicyCrudService ramGrantPolicyCrudService;

    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody GrantPolicy body) {
        long sid = this.ramGrantPolicyCrudService.insert(body);
        this.cacheHandlerService.grantPolicyChanged(sid);
        return StdData.ofSuccess((Object)BaseSid.ok(sid));
    }

    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody BaseSid body) {
        this.cacheHandlerService.grantPolicyChanged(body.getSid());
        int count = this.ramGrantPolicyCrudService.deleteBySid(body.getSid());
        return StdData.ofSuccess((Object)BaseSid.ok(count));
    }

    @PostMapping(value={"/find"})
    public StdData<?> find(@RequestBody GrantVO body) {
        body.setOrderBy("gp.create_date desc");
        return StdData.ofSuccess(this.ramGrantPolicyCrudService.findByPage0(body));
    }

    @PostMapping(value={"/find/grant"})
    public StdData<?> getGrant(@RequestBody GrantPolicy body) {
        List<GrantVO> grants = this.ramGrantPolicyCrudService.findByPolicySid(body.getPolicySid());
        return StdData.ofSuccess(grants);
    }

    @PostMapping(value={"/find/policy"})
    public StdData<?> getPolicy(@RequestBody GrantPolicy body) {
        List<PolicyVO> policies = this.ramGrantPolicyCrudService.findByGrantSid(body.getGrantSid());
        return StdData.ofSuccess(policies);
    }
}

