/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.service.CacheHandlerService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyCrudService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/ram/v2/policy"})
@RestController
public class PolicyApi {
    @Autowired
    private CacheHandlerService cacheHandlerService;
    @Autowired
    private RamPolicyCrudService ramPolicyCrudService;
    @Autowired
    private RamPolicyRouteCrudService ramPolicyRouteCrudService;

    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody Policy body) {
        long sid = this.ramPolicyCrudService.insert(body);
        return StdData.ofSuccess((Object)BaseSid.ok(sid));
    }

    @Transactional
    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody BaseSid body) {
        Policy policy = this.ramPolicyCrudService.findBySid(body.getSid());
        if (policy != null) {
            this.cacheHandlerService.policyChanged(policy.getType(), policy.getId());
            int count = this.ramPolicyCrudService.deleteBySid(body.getSid());
            this.ramPolicyRouteCrudService.deleteByPolicySid(body.getSid());
            return StdData.ofSuccess((Object)BaseSid.ok(count));
        }
        return StdData.ofSuccess((Object)BaseSid.ok(0L));
    }

    @PostMapping(value={"/mod"})
    public StdData<?> mod(@RequestBody Policy body) {
        Policy policy = this.ramPolicyCrudService.findBySid(body.getSid());
        if (policy != null) {
            policy.setName(body.getName());
            this.ramPolicyCrudService.update(policy);
            return StdData.ofSuccess((Object)BaseSid.ok(policy.getSid()));
        }
        return StdData.ofSuccess((Object)BaseSid.ok(0L));
    }

    @PostMapping(value={"/get"})
    public StdData<?> get(@RequestBody BaseSid body) {
        Policy path = this.ramPolicyCrudService.findBySid(body.getSid());
        if (path != null) {
            return StdData.ofSuccess((Object)path);
        }
        return StdData.ofSuccess((Object)BaseSid.ok(0L));
    }

    @PostMapping(value={"/find"})
    public StdData<?> find(@RequestBody PolicyVO body) {
        return StdData.ofSuccess(this.ramPolicyCrudService.findByPage(body));
    }

    @PostMapping(value={"/query"})
    public StdData<?> query(@RequestBody PolicyVO body) {
        body.setOrderBy("p.create_date desc");
        return StdData.ofSuccess(this.ramPolicyCrudService.findByPage0(body));
    }
}

