/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.PolicyRoute;
import com.digiwin.dap.middle.ram.service.CacheHandlerService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middleware.domain.StdData;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/ram/v2/pr"})
@RestController
public class PolicyRouteApi {
    @Autowired
    private CacheHandlerService cacheHandlerService;
    @Autowired
    private RamPolicyRouteCrudService ramPolicyRouteCrudService;

    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody PolicyRoute body) {
        long sid = this.ramPolicyRouteCrudService.insert(body);
        this.cacheHandlerService.policyRouteChanged(sid);
        return StdData.ofSuccess((Object)BaseSid.ok(sid));
    }

    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody BaseSid body) {
        this.cacheHandlerService.policyRouteChanged(body.getSid());
        int count = this.ramPolicyRouteCrudService.deleteBySid(body.getSid());
        return StdData.ofSuccess((Object)BaseSid.ok(count));
    }

    @PostMapping(value={"/find/policy"})
    public StdData<?> getPolicy(@RequestBody PolicyRoute body) {
        List<PolicyVO> policies = this.ramPolicyRouteCrudService.findByRouteSid(body.getRouteSid());
        return StdData.ofSuccess(policies);
    }

    @PostMapping(value={"/find/route"})
    public StdData<?> getRoute(@RequestBody PolicyRoute body) {
        List<RouteVO> routes = this.ramPolicyRouteCrudService.findByPolicySid(body.getPolicySid());
        return StdData.ofSuccess(routes);
    }
}

