/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.service.CacheHandlerService;
import com.digiwin.dap.middle.ram.service.base.RamRouteCrudService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/ram/v2/route"})
@RestController
public class RouteApi {
    @Autowired
    private CacheHandlerService cacheHandlerService;
    @Autowired
    private RamRouteCrudService ramRouteCrudService;

    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody Route body) {
        long routeSid = this.ramRouteCrudService.insert(body);
        return StdData.ofSuccess((Object)BaseSid.ok(routeSid));
    }

    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody BaseSid body) {
        Route route = this.ramRouteCrudService.findBySid(body.getSid());
        if (route != null) {
            this.cacheHandlerService.routeChanged(route.getSid());
            int count = this.ramRouteCrudService.deleteBySid(body.getSid());
            return StdData.ofSuccess((Object)BaseSid.ok(count));
        }
        return StdData.ofSuccess((Object)BaseSid.ok(0L));
    }

    @PostMapping(value={"/get"})
    public StdData<?> get(@RequestBody BaseSid body) {
        Route route = this.ramRouteCrudService.findBySid(body.getSid());
        if (route != null) {
            return StdData.ofSuccess((Object)route);
        }
        return StdData.ofSuccess((Object)BaseSid.ok(0L));
    }

    @PostMapping(value={"/find"})
    public StdData<?> find(@RequestBody RouteVO body) {
        return StdData.ofSuccess(this.ramRouteCrudService.findByPage(body));
    }

    @PostMapping(value={"/query"})
    public StdData<?> query(@RequestBody RouteVO body) {
        body.setOrderBy("r.create_date desc");
        return StdData.ofSuccess(this.ramRouteCrudService.findByPage0(body));
    }
}

