/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.constant;

import com.digiwin.dap.middle.ram.util.I18nUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;

public enum I18nError implements ErrorHandler
{
    APP_TOKEN_NONE("20000", "dap.middleware.ram.app.token.none"),
    APP_AUTH_CHECK("20000", "dap.middleware.ram.app.auth.check"),
    AUTH_CHECK_21006("21006", "dap.middleware.ram.app.auth.check.21006"),
    AUTH_CHECK_21007("21007", "dap.middleware.ram.app.auth.check.21007"),
    AUTH_CHECK_21008("21008", "dap.middleware.ram.app.auth.check.21008");

    private final String errorCode;
    private final String code;

    private I18nError(String errorCode, String code) {
        this.errorCode = errorCode;
        this.code = code;
    }

    public static boolean containsCode(String code) {
        for (I18nError value : I18nError.values()) {
            if (!value.getCode().equals(code)) continue;
            return true;
        }
        return false;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getCode() {
        return this.code;
    }

    public String getErrorMessage() {
        return I18nUtils.getAccessor().getMessage(this.code);
    }
}

