/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.domain;

import com.digiwin.dap.middle.ram.domain.AuthResult;
import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.util.TokenUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TargetInfo {
    private final Map<TargetType, String> targets = new LinkedHashMap<TargetType, String>(3);
    private AuthoredUser user;
    private AuthoredSys sys;
    private PatternVO pattern;
    private ResultType resultType = ResultType.IMPLICIT_DENY;
    private AuthResult authResult = new AuthResult();
    private boolean obsolete;

    public void init() {
        if (this.targets.isEmpty()) {
            this.user = TokenUtils.getAuthoredUser();
            this.sys = TokenUtils.getAuthoredSys();
            if (this.user != null) {
                if (this.user.getTenantId() != null) {
                    this.targets.put(TargetType.Tenant, this.user.getTenantId());
                }
                this.targets.put(TargetType.User, this.user.getUserId());
            }
            if (this.sys != null) {
                this.targets.put(TargetType.Sys, this.sys.getId());
            }
        }
    }

    public List<TargetType> targets() {
        return new ArrayList<TargetType>(this.targets.keySet());
    }

    public String obtain(TargetType targetType) {
        return this.targets.get((Object)targetType);
    }

    public String functionKey() {
        return String.format("iam:permission:all:%s::%s::%s", this.targets.get((Object)TargetType.User), this.targets.get((Object)TargetType.Tenant), this.targets.get((Object)TargetType.Sys));
    }

    public AuthoredUser getUser() {
        return this.user;
    }

    public AuthoredSys getSys() {
        return this.sys;
    }

    public PatternVO getPattern() {
        return this.pattern;
    }

    public void setPattern(PatternVO pattern) {
        this.pattern = pattern;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }

    public AuthResult getAuthResult() {
        return this.authResult;
    }

    public void setAuthResult(AuthResult authResult) {
        this.authResult = authResult;
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public void setObsolete(boolean obsolete) {
        this.obsolete = obsolete;
    }
}

