/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.domain.function;

import com.digiwin.dap.middleware.cache.RedisUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Function {
    public static final String REDIS_PERMISSION_KEY = "iam:permission:all:%s::%s::%s";
    private Result result = new Result();

    public static List<String> obtainPolicyIds(String key) {
        ArrayList<String> policyIds = new ArrayList<String>();
        Function function = (Function)RedisUtils.get((Object)key, Function.class);
        if (function == null || function.getResult() == null) {
            return policyIds;
        }
        List actionIds = function.getResult().getPermissions().stream().map(Result.Permission::getId).collect(Collectors.toList());
        List conditionIds = function.getResult().getPermissions().stream().flatMap(action -> action.getConditions().entrySet().stream()).flatMap(condition -> ((Map)condition.getValue()).entrySet().stream()).map(Map.Entry::getKey).collect(Collectors.toList());
        policyIds.addAll(actionIds);
        policyIds.addAll(conditionIds);
        return policyIds;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public static class Result {
        private List<Permission> permissions;

        public List<Permission> getPermissions() {
            return this.permissions;
        }

        public void setPermissions(List<Permission> permissions) {
            this.permissions = permissions;
        }

        public static class Permission {
            private String id;
            private String target;
            private Map<String, Map<String, String>> conditions;

            public String getId() {
                return this.id;
            }

            public void setId(String id) {
                this.id = id;
            }

            public String getTarget() {
                return this.target;
            }

            public void setTarget(String target) {
                this.target = target;
            }

            public Map<String, Map<String, String>> getConditions() {
                return this.conditions;
            }

            public void setConditions(Map<String, Map<String, String>> conditions) {
                this.conditions = conditions;
            }
        }
    }
}

