/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.filter;

import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.TargetInfoContextHolder;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.PolicyTypeChain;
import com.digiwin.dap.middle.ram.service.policy.filiter.PolicyFilterHandler;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

public class AfterAuthenticationFilter
extends OncePerRequestFilter
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(AfterAuthenticationFilter.class);
    private final DapEnv dapEnv;
    private final List<PolicyFilterHandler> policyHandlers;

    public AfterAuthenticationFilter(DapEnv dapEnv, List<PolicyFilterHandler> policyHandlers) {
        this.dapEnv = dapEnv;
        this.policyHandlers = policyHandlers;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        TargetInfo targetInfo = TargetInfoContextHolder.getTargetInfo();
        targetInfo.init();
        try {
            if (ResultType.IMPLICIT_DENY == targetInfo.getResultType()) {
                PolicyTypeChain policyTypeChain = new PolicyTypeChain(this.policyHandlers);
                ResultType result = policyTypeChain.doNextStep(targetInfo, request);
                targetInfo.setResultType(result);
            }
        }
        catch (Exception e) {
            logger.error("RAM after authentication filter handler error", (Throwable)e);
        }
        if (targetInfo.getResultType() == ResultType.EXPLICIT_DENY) {
            ExceptionUtils.writeUnAuth((HttpServletRequest)request, (HttpServletResponse)response, (String)this.dapEnv.getAppName(), (ErrorHandler)targetInfo.getResultType());
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public int getOrder() {
        return FilterOrderEnum.AFTER_SECURITY.order();
    }
}

