/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.filter;

import com.digiwin.dap.middle.ram.constant.I18nError;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.TargetInfoContextHolder;
import com.digiwin.dap.middle.ram.service.policy.auth.AuthCheckHandler;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import com.digiwin.dap.middleware.exception.DapException;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

public class AuthCheckFilter
extends OncePerRequestFilter
implements Ordered {
    private final DapEnv dapEnv;
    private final AuthCheckHandler authCheckHandler;

    public AuthCheckFilter(DapEnv dapEnv, AuthCheckHandler authCheckHandler) {
        this.dapEnv = dapEnv;
        this.authCheckHandler = authCheckHandler;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        TargetInfo targetInfo = TargetInfoContextHolder.getTargetInfo();
        targetInfo.init();
        try {
            if (request.getRequestURI().startsWith("/api/ram")) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (request.getRequestURI().startsWith("/api/iam/v2/identity/login")) {
                targetInfo.getAuthResult().setDisabled(true);
            }
            this.authCheckHandler.processAuthWithCheck(targetInfo, request);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (DapException e) {
            ExceptionUtils.writeUnAuth((HttpServletRequest)request, (HttpServletResponse)response, (String)this.dapEnv.getAppName(), (Exception)((Object)e));
        }
        catch (Exception e) {
            ExceptionUtils.writeUnAuth((HttpServletRequest)request, (HttpServletResponse)response, (String)this.dapEnv.getAppName(), (ErrorHandler)I18nError.APP_AUTH_CHECK);
        }
    }

    public int getOrder() {
        return FilterOrderEnum.APP_CHECK.order();
    }
}

