/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.filter;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PathMatcher;

public class MappingRegistry {
    private static final PathMatcher pathMatcher = new AntPathMatcher();
    private final List<PatternVO> mappings = new ArrayList<PatternVO>();
    private final MultiValueMap<String, PatternVO> urlLookup = new LinkedMultiValueMap();

    public MappingRegistry() {
    }

    public MappingRegistry(List<PatternVO> mappings) {
        for (PatternVO mapping : mappings) {
            if (pathMatcher.isPattern(mapping.getPath())) {
                this.mappings.add(mapping);
                continue;
            }
            this.urlLookup.add((Object)mapping.getPath(), (Object)mapping);
        }
    }

    public static PathMatcher getPathMatcher() {
        return pathMatcher;
    }

    public List<PatternVO> getMappings() {
        return this.mappings;
    }

    public List<PatternVO> getMappingsByUrl(String urlPath) {
        return (List)this.urlLookup.get((Object)urlPath);
    }

    public boolean isEmpty() {
        return this.mappings.isEmpty() && this.urlLookup.isEmpty();
    }
}

