/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.filter;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.filter.MappingRegistry;
import com.digiwin.dap.middle.ram.mapper.RamRouteCrudMapper;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;

@Component
public class PatternRegistry {
    private final Map<PatternVO, RequestMatcher> registry = new HashMap<PatternVO, RequestMatcher>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    @Autowired
    private RamRouteCrudMapper ramRouteCrudMapper;

    public Map<PatternVO, RequestMatcher> getRegistry() {
        this.readWriteLock.readLock().lock();
        try {
            Map<PatternVO, RequestMatcher> map = this.registry;
            return map;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(List<Route> routes) {
        this.readWriteLock.writeLock().lock();
        try {
            for (Route route : routes) {
                if (!MappingRegistry.getPathMatcher().isPattern(route.getPath())) continue;
                AntPathRequestMatcher matcher = new AntPathRequestMatcher(route.getPath(), route.getMethod());
                this.registry.put(new PatternVO(route), (RequestMatcher)matcher);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void register(PatternVO route, RequestMatcher matcher) {
        this.readWriteLock.writeLock().lock();
        try {
            this.registry.put(route, matcher);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void initData() {
        List<Route> routes = this.ramRouteCrudMapper.findAll();
        this.register(routes);
        MatcherUtils.setRouteRegistry(this);
    }
}

