/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service;

import com.digiwin.dap.middle.ram.constant.CacheConstant;
import com.digiwin.dap.middle.ram.domain.GrantPolicyVO;
import com.digiwin.dap.middle.ram.domain.PolicyRouteVO;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.mapper.RamCacheMapper;
import com.digiwin.dap.middleware.cache.RedisUtils;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CacheHandlerService {
    @Value(value="${spring.application.name:dap}")
    private String appName;
    @Autowired
    private RamCacheMapper ramCacheMapper;

    public void grantChanged(String targetType, String targetId) {
        Set keys = RedisUtils.keys((String)CacheConstant.getGrantTarget(this.appName, "*", targetType, targetId));
        keys.forEach(RedisUtils::delete);
    }

    public void policyChanged(String policyType, String policyId) {
        RedisUtils.delete((String)CacheConstant.getPolicyId(this.appName, policyType, policyId));
    }

    public void routeChanged(long routeSid) {
        List<PolicyRouteVO> caches = this.ramCacheMapper.findPolicyRouteByRouteSid(routeSid);
        for (PolicyRouteVO cache : caches) {
            this.handleCache(cache);
        }
    }

    public void policyRouteChanged(long policyRouteSid) {
        PolicyRouteVO cache = this.ramCacheMapper.findPolicyRouteBySid(policyRouteSid);
        if (cache == null) {
            return;
        }
        this.handleCache(cache);
    }

    public void grantPolicyChanged(long policyRouteSid) {
        GrantPolicyVO cache = this.ramCacheMapper.findGrantPolicyBySid(policyRouteSid);
        if (cache == null) {
            return;
        }
        this.handleCache(cache);
    }

    private void handleCache(PolicyRouteVO cache) {
        if (PolicyType.None.name().equals(cache.getPolicyType()) || PolicyType.AllowList.name().equals(cache.getPolicyType()) || PolicyType.BlockList.name().equals(cache.getPolicyType())) {
            RedisUtils.delete((String)CacheConstant.getPolicyType(this.appName, cache.getPolicyType()));
        } else if (PolicyType.Base.name().equals(cache.getPolicyType())) {
            RedisUtils.delete((String)CacheConstant.getPolicyId(this.appName, cache.getPolicyType(), cache.getPolicyId()));
        } else if (PolicyType.Function.name().equals(cache.getPolicyType()) || PolicyType.Obsolete.name().equals(cache.getPolicyType())) {
            RedisUtils.delete((String)CacheConstant.getPolicyPath(this.appName, cache.getPolicyType(), cache.getMethod(), cache.getPath()));
        }
    }

    private void handleCache(GrantPolicyVO cache) {
        if (PolicyType.AllowList.name().equals(cache.getPolicyType()) || PolicyType.BlockList.name().equals(cache.getPolicyType()) || PolicyType.Base.name().equals(cache.getPolicyType()) || PolicyType.NoAuthApp.name().equals(cache.getPolicyType()) || PolicyType.NoAuthUser.name().equals(cache.getPolicyType())) {
            RedisUtils.delete((String)CacheConstant.getGrantTarget(this.appName, cache.getPolicyType(), cache.getTargetType(), cache.getTargetId()));
        }
    }
}

