/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.filter.MappingRegistry;
import com.digiwin.dap.middle.ram.service.executor.GrantExecutor;
import com.digiwin.dap.middle.ram.service.executor.PolicyExecutor;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@CacheConfig(cacheNames={"12h"}, cacheManager="dapCacheManager")
@Service
public class PolicyQueryService {
    @Autowired
    private GrantExecutor grantExecutor;
    @Autowired
    private PolicyExecutor policyExecutor;

    @Cacheable(key="T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_POLICY + #policyType")
    public MappingRegistry getPattern(String policyType) {
        List<PatternVO> patterns = this.policyExecutor.findPolicyByType(policyType);
        return new MappingRegistry(patterns);
    }

    public Statement getTargetPolicy(String policyType, String targetType, String targetId) {
        ArrayList<PatternVO> routes = new ArrayList<PatternVO>();
        List<String> policyIds = this.grantExecutor.findPolicyIdByTarget(policyType, targetType, targetId);
        for (String policyId : policyIds) {
            routes.addAll(this.policyExecutor.findPolicyById(policyType, policyId));
        }
        return new Statement(routes);
    }

    public List<String> findPolicyIdByPath(String policyType, String method, String path) {
        return this.policyExecutor.findPolicyIdByPath(policyType, method, path);
    }

    public List<String> findPolicyIdByTarget(String policyType, String targetType, String targetId) {
        return this.grantExecutor.findPolicyIdByTarget(policyType, targetType, targetId);
    }
}

