/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service;

import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.policy.PolicyHandler;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public final class PolicyTypeChain {
    private final List<? extends PolicyHandler> policyHandlers;
    private final int size;
    private int currentPosition = 0;

    public PolicyTypeChain(List<? extends PolicyHandler> policyHandlers) {
        this.policyHandlers = policyHandlers;
        this.size = policyHandlers.size();
    }

    public ResultType doNextStep(TargetInfo targetInfo, HttpServletRequest request) {
        if (this.currentPosition == this.size) {
            return ResultType.IMPLICIT_DENY;
        }
        ++this.currentPosition;
        PolicyHandler nextPolicyHandler = this.policyHandlers.get(this.currentPosition - 1);
        ResultType resultType = nextPolicyHandler.matches(targetInfo, request);
        if (ResultType.IMPLICIT_DENY == resultType) {
            return this.doNextStep(targetInfo, request);
        }
        return resultType;
    }
}

