/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service;

import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.service.policy.filiter.PolicyFilterHandler;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public final class TargetTypeChain {
    private final List<TargetType> targetTypes;
    private final int size;
    private final PolicyFilterHandler policyFilterHandler;
    private int currentPosition = 0;

    private TargetTypeChain(PolicyFilterHandler policyFilterHandler, List<TargetType> targetTypes) {
        this.policyFilterHandler = policyFilterHandler;
        this.targetTypes = targetTypes;
        this.size = targetTypes.size();
    }

    public static TargetTypeChain getInstance(PolicyFilterHandler policyHandler, List<TargetType> targetTypes) {
        return new TargetTypeChain(policyHandler, targetTypes);
    }

    public ResultType matches(TargetInfo targetInfo, HttpServletRequest request) {
        if (this.currentPosition == this.size) {
            return ResultType.IMPLICIT_DENY;
        }
        ++this.currentPosition;
        TargetType nextTargetType = this.targetTypes.get(this.currentPosition - 1);
        ResultType resultType = this.policyFilterHandler.matches(nextTargetType.name(), targetInfo.obtain(nextTargetType), request);
        if (ResultType.IMPLICIT_DENY == resultType) {
            return this.matches(targetInfo, request);
        }
        return resultType;
    }
}

