/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.base;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.mapper.RamGrantCrudMapper;
import com.digiwin.dap.middle.ram.service.base.RamBaseService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamGrantCrudService
implements RamBaseService<Grant> {
    @Autowired
    private RamGrantCrudMapper ramGrantCrudMapper;

    @Override
    public long insert(Grant data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        this.ramGrantCrudMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return this.ramGrantCrudMapper.deleteBySid(sid);
    }

    @Override
    public long update(Grant data) {
        BaseUtils.setCreateFields(data);
        this.ramGrantCrudMapper.update(data);
        return data.getSid();
    }

    @Override
    public Grant findBySid(long sid) {
        return this.ramGrantCrudMapper.findBySid(sid);
    }

    @Override
    public boolean existsBySid(long sid) {
        return this.ramGrantCrudMapper.existsBySid(sid);
    }

    @Override
    public PageData<Grant> findByPage(Page page) {
        long total = this.ramGrantCrudMapper.countByPage(page);
        if (total == 0L) {
            return PageData.empty();
        }
        List<Grant> paths = this.ramGrantCrudMapper.findByPage(page.offsetPage());
        return PageData.data(total, paths);
    }

    public PageData<GrantVO> findByPage0(Page page) {
        long total = this.ramGrantCrudMapper.countByPage(page);
        if (total == 0L) {
            return PageData.empty();
        }
        List<GrantVO> paths = this.ramGrantCrudMapper.findByPage0(page.offsetPage());
        return PageData.data(total, paths);
    }
}

