/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.base;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.entity.GrantPolicy;
import com.digiwin.dap.middle.ram.mapper.RamGrantPolicyCrudMapper;
import com.digiwin.dap.middle.ram.service.base.RamBaseService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamGrantPolicyCrudService
implements RamBaseService<GrantPolicy> {
    @Autowired
    private RamGrantPolicyCrudMapper ramGrantPolicyCrudMapper;

    @Override
    public long insert(GrantPolicy data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        this.ramGrantPolicyCrudMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return this.ramGrantPolicyCrudMapper.deleteBySid(sid);
    }

    public int deleteByGrantSid(long grantSid) {
        return this.ramGrantPolicyCrudMapper.deleteByGrantSid(grantSid);
    }

    public List<GrantVO> findByPolicySid(long policySid) {
        return this.ramGrantPolicyCrudMapper.findByPolicySid(policySid);
    }

    public List<PolicyVO> findByGrantSid(long grantSid) {
        return this.ramGrantPolicyCrudMapper.findByGrantSid(grantSid);
    }

    public PageData<GrantVO> findByPage0(Page page) {
        long total = this.ramGrantPolicyCrudMapper.countByPage(page);
        if (total == 0L) {
            return PageData.empty();
        }
        List<GrantVO> paths = this.ramGrantPolicyCrudMapper.findByPage(page.offsetPage());
        return PageData.data(total, paths);
    }
}

