/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.base;

import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.mapper.RamRouteCrudMapper;
import com.digiwin.dap.middle.ram.service.base.RamBaseService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamRouteCrudService
implements RamBaseService<Route> {
    @Autowired
    private RamRouteCrudMapper ramRouteCrudMapper;

    @Override
    public long insert(Route data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        this.ramRouteCrudMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return this.ramRouteCrudMapper.deleteBySid(sid);
    }

    @Override
    public long update(Route data) {
        BaseUtils.setCreateFields(data);
        this.ramRouteCrudMapper.update(data);
        return data.getSid();
    }

    @Override
    public Route findBySid(long sid) {
        return this.ramRouteCrudMapper.findBySid(sid);
    }

    @Override
    public boolean existsBySid(long sid) {
        return this.ramRouteCrudMapper.existsBySid(sid);
    }

    @Override
    public PageData<Route> findByPage(Page page) {
        long total = this.ramRouteCrudMapper.countByPage(page);
        if (total == 0L) {
            return PageData.empty();
        }
        List<Route> routes = this.ramRouteCrudMapper.findByPage(page.offsetPage());
        return PageData.data(total, routes);
    }

    public PageData<RouteVO> findByPage0(Page page) {
        long total = this.ramRouteCrudMapper.countByPage(page);
        if (total == 0L) {
            return PageData.empty();
        }
        List<RouteVO> paths = this.ramRouteCrudMapper.findByPageCount(page.offsetPage());
        return PageData.data(total, paths);
    }
}

