/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.executor;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.service.executor.PolicyExecutor;
import java.util.List;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;

@CacheConfig(cacheNames={"12h"}, cacheManager="dapCacheManager")
public class PolicyCachingExecutor
implements PolicyExecutor {
    private final PolicyExecutor delegate;

    public PolicyCachingExecutor(PolicyExecutor delegate) {
        this.delegate = delegate;
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_POLICY + #policyType + ':' + #policyId")
    public List<PatternVO> findPolicyById(String policyType, String policyId) {
        return this.delegate.findPolicyById(policyType, policyId);
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_POLICY + #policyType")
    public List<PatternVO> findPolicyByType(String policyType) {
        return this.delegate.findPolicyByType(policyType);
    }

    @Override
    @Cacheable(key="T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_POLICY + #policyType + ':{' + #method + ' ' + #path + '}'")
    public List<String> findPolicyIdByPath(String policyType, String method, String path) {
        return this.delegate.findPolicyIdByPath(policyType, method, path);
    }
}

