/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.policy.auth;

import com.digiwin.dap.middle.ram.constant.I18nError;
import com.digiwin.dap.middle.ram.domain.AuthResult;
import com.digiwin.dap.middle.ram.domain.enums.AuthType;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.service.policy.auth.AuthCheckHandler;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import org.springframework.core.annotation.Order;

@Order(value=0)
public class BeforeAuthCheckHandler
extends AuthCheckHandler {
    private final DapEnv dapEnv;

    public BeforeAuthCheckHandler(DapEnv dapEnv, PolicyQueryService policyQueryService) {
        this.dapEnv = dapEnv;
        this.policyQueryService = policyQueryService;
    }

    @Override
    public boolean supports(AuthType authType) {
        return true;
    }

    @Override
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys) {
        boolean notCheck;
        boolean needCheck;
        if (authResult.isDisabled()) {
            authResult.setAuthType(AuthType.AppOk);
            return authResult;
        }
        boolean bl = needCheck = this.dapEnv.isRamAppCheck() && sys == null;
        if (needCheck) {
            throw new BusinessException((ErrorHandler)I18nError.APP_TOKEN_NONE);
        }
        boolean bl2 = notCheck = user == null || user.getTenantId() == null || sys == null || sys.getId() == null || sys.isInside() || "integration".equals(user.getUserId());
        if (notCheck) {
            authResult.setAuthType(AuthType.AppOk);
        }
        return authResult;
    }
}

