/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.policy.auth;

import com.digiwin.dap.middle.ram.domain.AuthResult;
import com.digiwin.dap.middle.ram.domain.enums.AuthType;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.service.policy.auth.AuthCheckHandler;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import java.util.List;
import org.springframework.core.annotation.Order;

@Order(value=20)
public class NoAuthUserAuthCheckHandler
extends AuthCheckHandler {
    public NoAuthUserAuthCheckHandler(PolicyQueryService policyQueryService) {
        this.policyQueryService = policyQueryService;
    }

    @Override
    public boolean supports(AuthType authType) {
        return authType == AuthType.AppNoneUser;
    }

    @Override
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys) {
        List<String> policyId = this.policyQueryService.findPolicyIdByTarget(PolicyType.NoAuthUser.name(), TargetType.TenantSys.name(), user.getTenantId() + '-' + sys.getId());
        if (!policyId.isEmpty()) {
            authResult.setAuthType(AuthType.AppOk);
        }
        return authResult;
    }
}

