/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.policy.filiter;

import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.filter.MappingRegistry;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.service.TargetTypeChain;
import com.digiwin.dap.middle.ram.service.policy.filiter.PolicyFilterHandler;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.annotation.Order;

@Order(value=2)
public class AllowListPolicyFilterHandler
extends PolicyFilterHandler {
    public AllowListPolicyFilterHandler(PolicyQueryService policyQueryService) {
        super(policyQueryService);
    }

    @Override
    public ResultType matches(TargetInfo targetInfo, HttpServletRequest request) {
        boolean matched;
        MappingRegistry mappingRegistry = this.policyQueryService.getPattern(PolicyType.AllowList.name());
        if (!mappingRegistry.isEmpty() && (matched = MatcherUtils.matches(request, mappingRegistry))) {
            ResultType resultType = TargetTypeChain.getInstance(this, targetInfo.targets()).matches(targetInfo, request);
            return resultType == ResultType.ALLOW ? ResultType.ALLOW : ResultType.EXPLICIT_DENY;
        }
        return ResultType.IMPLICIT_DENY;
    }

    @Override
    public ResultType matches(String targetType, String targetId, HttpServletRequest request) {
        return super.matches(PolicyType.AllowList.name(), targetType, targetId, request);
    }
}

