/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.policy.filiter;

import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.service.policy.PolicyHandler;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import javax.servlet.http.HttpServletRequest;

public abstract class PolicyFilterHandler
implements PolicyHandler {
    protected PolicyQueryService policyQueryService;

    public PolicyFilterHandler() {
    }

    public PolicyFilterHandler(PolicyQueryService policyQueryService) {
        this.policyQueryService = policyQueryService;
    }

    public ResultType matches(String targetType, String targetId, HttpServletRequest request) {
        return ResultType.IMPLICIT_DENY;
    }

    protected ResultType matches(String policyType, String targetType, String targetId, HttpServletRequest request) {
        boolean matched;
        Statement statement = this.policyQueryService.getTargetPolicy(policyType, targetType, targetId);
        if (!statement.getDeny().isEmpty() && (matched = MatcherUtils.matches(request, statement.getDeny()))) {
            return ResultType.EXPLICIT_DENY;
        }
        if (!statement.getAllow().isEmpty() && (matched = MatcherUtils.matches(request, statement.getAllow()))) {
            return ResultType.ALLOW;
        }
        return ResultType.IMPLICIT_DENY;
    }
}

