/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.policy.interceptor;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.function.Function;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.service.policy.interceptor.PolicyInterceptorHandler;
import java.util.List;
import org.springframework.core.annotation.Order;

@Order(value=11)
public class FunctionPolicyInterceptorHandler
extends PolicyInterceptorHandler {
    public FunctionPolicyInterceptorHandler(PolicyQueryService policyQueryService) {
        super(policyQueryService);
    }

    @Override
    public ResultType matches(TargetInfo targetInfo, PatternVO pattern) {
        List<String> actionIds = this.policyQueryService.findPolicyIdByPath(PolicyType.Function.name(), pattern.getMethod(), pattern.getPath());
        boolean match = Function.obtainPolicyIds(targetInfo.functionKey()).stream().anyMatch(actionIds::contains);
        if (match) {
            return ResultType.ALLOW;
        }
        return ResultType.IMPLICIT_DENY;
    }
}

