/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.util;

import com.digiwin.dap.middle.ram.constant.I18nError;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.AuthType;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.UnauthorizedException;

public class AuthUtils {
    public static void checkAuthResult(TargetInfo targetInfo) {
        AuthUtils.checkAuthResult(targetInfo.getAuthResult().getAuthType(), targetInfo.getUser(), targetInfo.getSys());
    }

    public static void checkAuthResult(AuthType authType, AuthoredUser user, AuthoredSys sys) {
        if (authType == AuthType.AppNone) {
            String message = String.format("\u79df\u6237[%s]\u5c1a\u672a\u8d2d\u4e70\u5e94\u7528[%s]", user.getTenantId(), sys.getId());
            throw new UnauthorizedException((ErrorHandler)I18nError.AUTH_CHECK_21006, 411002, message);
        }
        if (authType == AuthType.AppExpired) {
            String message = String.format("\u79df\u6237[%s]\u8d2d\u4e70\u7684\u5e94\u7528[%s]\u6388\u6743\u5df2\u8fc7\u671f", user.getTenantId(), sys.getId());
            throw new UnauthorizedException((ErrorHandler)I18nError.AUTH_CHECK_21008, 411004, message);
        }
        if (authType == AuthType.AppNoneUser) {
            String message = String.format("\u79df\u6237[%s]\u7528\u6237[%s]\u5c1a\u672a\u5f97\u5230\u5e94\u7528[%s]\u7684\u6388\u6743", user.getTenantId(), user.getUserId(), sys.getId());
            throw new UnauthorizedException((ErrorHandler)I18nError.AUTH_CHECK_21007, 411003, message);
        }
    }
}

