/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.util;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.filter.MappingRegistry;
import com.digiwin.dap.middle.ram.filter.PatternRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class MatcherUtils {
    private static final Logger logger = LoggerFactory.getLogger(MatcherUtils.class);
    private static PatternRegistry patternRegistry;

    public static boolean matches(HttpServletRequest request, MappingRegistry mappingRegistry) {
        List<PatternVO> directPathMatches = mappingRegistry.getMappingsByUrl(request.getServletPath());
        if (directPathMatches != null) {
            for (PatternVO patternVO : directPathMatches) {
                if (patternVO.getMethod() != null && !patternVO.getMethod().equals(request.getMethod())) continue;
                logger.debug("matched " + patternVO);
                return true;
            }
        }
        for (RequestMatcher requestMatcher : MatcherUtils.getAntMatchers(mappingRegistry.getMappings())) {
            if (!requestMatcher.matches(request)) continue;
            logger.debug("matched " + requestMatcher);
            return true;
        }
        logger.debug("No matches found");
        return false;
    }

    private static List<RequestMatcher> getAntMatchers(List<PatternVO> mappings) {
        ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
        for (PatternVO mapping : mappings) {
            if (patternRegistry.getRegistry().containsKey(mapping)) {
                matchers.add(patternRegistry.getRegistry().get(mapping));
                continue;
            }
            AntPathRequestMatcher matcher = new AntPathRequestMatcher(mapping.getPath(), mapping.getMethod());
            matchers.add((RequestMatcher)matcher);
            patternRegistry.register(mapping, (RequestMatcher)matcher);
        }
        return matchers;
    }

    public static void setRouteRegistry(PatternRegistry patternRegistry) {
        MatcherUtils.patternRegistry = patternRegistry;
    }
}

