package com.digiwin.dap.middle.ram.constant;

import com.digiwin.dap.middle.ram.service.core.RamMessageSource;
import com.digiwin.dap.middleware.domain.ErrorHandler;

/**
 * 统一错误码
 *
 * @author fobgochod
 * @date 2020/6/7
 */
public enum I18nError implements ErrorHandler {

    /**
     * appToken 授权检查异常
     */
    APP_AUTH_CHECK("20000", "dap.middleware.ram.app.auth.check");

    private final String errorCode;
    private final String code;

    I18nError(String errorCode, String code) {
        this.errorCode = errorCode;
        this.code = code;
    }

    public static boolean containsCode(String code) {
        for (I18nError value : I18nError.values()) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getErrorCode() {
        return errorCode;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getErrorMessage() {
        return RamMessageSource.getAccessor().getMessage(code);
    }
}
