package com.digiwin.dap.middle.ram.service.access.policy;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.access.TargetTypeChain;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import org.springframework.core.annotation.Order;

/**
 * 功能权限，策略类型 {@link PolicyType#Base}
 * <p>
 * 系统策略和用户自定义策略，按照最小单元判定流程匹配 {@link ResultType}
 *
 * @author fobgochod
 * @date 2021/9/18 21:04
 */
@Order(300)
public class BasePolicyFilterHandler extends PolicyFilterHandler {

    public BasePolicyFilterHandler(RamCoreService ramCoreService) {
        super(ramCoreService);
    }

    @Override
    public ResultType matches(AppAuthContext context, RequestInfo request) {
        return TargetTypeChain.getInstance(this, TargetInfo.getTargets(context)).matches(request);
    }

    @Override
    public ResultType matches(String targetType, String targetId, RequestInfo request) {
        Statement statement = ramCoreService.getPolicyRoute(request.getAppId(), PolicyType.Base.name(), targetType, targetId);
        if (!statement.getDeny().isEmpty()) {
            PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), statement.getDeny());
            if (matched != null) {
                return ResultType.EXPLICIT_DENY;
            }
        }
        if (!statement.getAllow().isEmpty()) {
            PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), statement.getAllow());
            if (matched != null) {
                return ResultType.ALLOW;
            }
        }
        return ResultType.IMPLICIT_DENY;
    }
}
