package com.digiwin.dap.middle.ram.service.access.policy;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.MappingRegistry;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import org.springframework.core.annotation.Order;

/**
 * 全局不参与，策略类型 {@link PolicyType#None}
 * <p>
 * 该策略下的API不做管控
 *
 * @author fobgochod
 * @date 2021/9/18 21:03
 */
@Order(100)
public class NonePolicyFilterHandler extends PolicyFilterHandler {

    public NonePolicyFilterHandler(RamCoreService ramCoreService) {
        super(ramCoreService);
    }

    @Override
    public ResultType matches(AppAuthContext context, RequestInfo request) {
        MappingRegistry mappingRegistry = ramCoreService.getPattern(request.getAppId(), PolicyType.None.name());
        PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), mappingRegistry);
        if (matched != null) {
            return ResultType.ALLOW;
        }
        return ResultType.IMPLICIT_DENY;
    }
}
