package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.entity.PolicyRoute;
import com.digiwin.dap.middle.ram.mapper.RamPolicyRouteMapper;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamPolicyRouteCrudServiceImpl implements RamPolicyRouteCrudService {

    @Autowired
    private RamPolicyRouteMapper ramPolicyRouteMapper;

    @Override
    public long insert(PolicyRoute data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        ramPolicyRouteMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramPolicyRouteMapper.deleteBySid(sid);
    }

    @Override
    public long update(PolicyRoute data) {
        ramPolicyRouteMapper.update(data);
        return data.getSid();
    }

    @Override
    public PolicyRoute findBySid(long sid) {
        return ramPolicyRouteMapper.findBySid(sid);
    }

    @Override
    public boolean exists(PolicyRoute data) {
        return ramPolicyRouteMapper.exists(data.getPolicySid(), data.getRouteSid());
    }

    public int deleteByPolicySid(long policySid) {
        return ramPolicyRouteMapper.deleteByPolicySid(policySid);
    }

    public List<PolicyVO> findByRouteSid(long policySid) {
        return ramPolicyRouteMapper.findByRouteSid(policySid);
    }

    public List<RouteVO> findByPolicySid(long routeSid) {
        return ramPolicyRouteMapper.findByPolicySid(routeSid);
    }
}
