package com.digiwin.dap.middle.ram.service.executor.cache;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.service.executor.RouteExecutor;
import com.digiwin.dap.middleware.constant.CacheConstants;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;

import java.util.List;

@CacheConfig(cacheNames = CacheConstants.TTL_12H, cacheManager = CacheConstants.DAP_CACHE_MANAGER)
public class RouteCachingExecutor implements RouteExecutor {

    private final RouteExecutor delegate;

    public RouteCachingExecutor(RouteExecutor delegate) {
        this.delegate = delegate;
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_ROUTE + #app")
    @Override
    public List<PatternVO> findRouteByApp(String app) {
        return delegate.findRouteByApp(app);
    }
}
