/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyCrudService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middle.ram.service.core.RamCacheService;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/ram/v2/policy"})
@RestController
public class RamPolicyController {
    @Autowired
    private RamCacheService ramCacheService;
    @Autowired
    private RamPolicyCrudService ramPolicyCrudService;
    @Autowired
    private RamGrantPolicyCrudService ramGrantPolicyCrudService;
    @Autowired
    private RamPolicyRouteCrudService ramPolicyRouteCrudService;

    @PostMapping(value={"/add"})
    public StdData<?> add(@RequestBody Policy body) {
        Policy policy;
        if (PolicyType.isSole(body.getType()) && (policy = this.ramPolicyCrudService.findByAppAndType(body.getApp(), body.getType())) != null) {
            throw new BusinessException(String.format("[%s]\u7c7b\u578b\u7b56\u7565\u4e00\u4e2a\u5e94\u7528\u53ea\u5141\u8bb8\u5efa\u7acb\u4e00\u4e2a", body.getType()));
        }
        long sid = this.ramPolicyCrudService.insert(body);
        return StdData.ofSuccess((Object)BaseSid.ok(sid));
    }

    @Transactional
    @PostMapping(value={"/del"})
    public StdData<?> del(@RequestBody BaseSid body) {
        Policy policy = (Policy)this.ramPolicyCrudService.findBySid(body.getSid());
        if (policy == null) {
            return StdData.ofSuccess((Object)BaseSid.ok(0L));
        }
        List<GrantVO> policyGrants = this.ramGrantPolicyCrudService.findByPolicySid(body.getSid());
        if (!policyGrants.isEmpty()) {
            String grant = policyGrants.stream().map(o -> o.getType() + "-" + o.getTargetId()).collect(Collectors.joining(","));
            throw new BusinessException(String.format("\u8be5\u7b56\u7565\u5b58\u5728\u6388\u6743\u4fe1\u606f[%s]\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", grant));
        }
        this.ramPolicyCrudService.deleteBySid(body.getSid());
        this.ramPolicyRouteCrudService.deleteByPolicySid(body.getSid());
        this.ramCacheService.policyRemove(policy);
        return StdData.ofSuccess((Object)BaseSid.ok(body.getSid()));
    }

    @PostMapping(value={"/mod"})
    public StdData<?> mod(@RequestBody Policy body) {
        Policy policy = (Policy)this.ramPolicyCrudService.findBySid(body.getSid());
        if (policy != null) {
            policy.setName(body.getName());
            this.ramPolicyCrudService.update(policy);
        }
        return StdData.ofSuccess((Object)policy);
    }

    @PostMapping(value={"/get"})
    public StdData<?> get(@RequestBody BaseSid body) {
        Policy path = (Policy)this.ramPolicyCrudService.findBySid(body.getSid());
        return StdData.ofSuccess((Object)path);
    }

    @PostMapping(value={"/find"})
    public StdData<?> find(@RequestBody Policy body) {
        return StdData.ofSuccess(this.ramPolicyCrudService.findByCond(body));
    }

    @PostMapping(value={"/query"})
    public StdData<?> query(@RequestBody Page<Policy> body) {
        body.setOrderBy("p.create_date desc");
        return StdData.ofSuccess(this.ramPolicyCrudService.findByPage(body));
    }
}

