/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.domain;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import java.util.ArrayList;
import java.util.List;

public class TargetInfo {
    private TargetType targetType;
    private String targetId;

    public TargetInfo() {
    }

    public TargetInfo(TargetType targetType, String targetId) {
        this.targetType = targetType;
        this.targetId = targetId;
    }

    public static List<TargetInfo> getTargets(AppAuthContext context) {
        AuthoredSys sys;
        ArrayList<TargetInfo> targets = new ArrayList<TargetInfo>();
        AuthoredUser user = context.getAuthoredUser();
        if (user != null) {
            targets.add(new TargetInfo(TargetType.User, user.getUserId()));
            if (user.getTenantId() != null) {
                targets.add(new TargetInfo(TargetType.Tenant, user.getTenantId()));
            }
        }
        if ((sys = context.getAuthoredSys()) != null) {
            targets.add(new TargetInfo(TargetType.Sys, sys.getId()));
        }
        return targets;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(TargetType targetType) {
        this.targetType = targetType;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }
}

