/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.page.Filter;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.mapper.RamPolicyMapper;
import com.digiwin.dap.middle.ram.service.base.RamPolicyCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamPolicyCrudServiceImpl
implements RamPolicyCrudService {
    @Autowired
    private RamPolicyMapper ramPolicyMapper;

    @Override
    public long insert(Policy data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        this.ramPolicyMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return this.ramPolicyMapper.deleteBySid(sid);
    }

    @Override
    public long update(Policy data) {
        BaseUtils.setModifyFields(data);
        this.ramPolicyMapper.update(data);
        return data.getSid();
    }

    @Override
    public Policy findBySid(long sid) {
        return this.ramPolicyMapper.findBySid(sid);
    }

    @Override
    public boolean exists(Policy data) {
        return this.ramPolicyMapper.exists(data.getSid());
    }

    @Override
    public PageData<PolicyVO> findByPage(Page<Policy> page) {
        Filter<Policy> filter = page.filter();
        long total = this.ramPolicyMapper.countByPage(filter.getEq(), filter);
        if (total == 0L) {
            return PageData.empty();
        }
        List<PolicyVO> paths = this.ramPolicyMapper.findByPage(filter.getEq(), filter);
        return PageData.data(total, paths);
    }

    @Override
    public List<Policy> findByCond(Policy data) {
        return this.ramPolicyMapper.findByCond(data);
    }

    @Override
    public Policy findByAppAndType(String appId, String policyType) {
        return this.ramPolicyMapper.findByAppAndType(appId, policyType);
    }
}

